﻿var outgoing = {
    datatable: null,
    refreshDataTable: function () {
        outgoing.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-outgoingMailTable").a4datatable({
            height: "full",
            stateKey: "DistributionsOutgoingMail",
            ajaxAction: a4.getAction("GetOutgoingMailConfigurations", "Distributions", "Settings"),
            allowRowSelection: canModifyOutgoing,
            columns: [
                { "Title": "Id", "Data": "Id", "Visible": false, "Key": true },
                { "Name": "DisplayName", "Title": resources.DisplayName, "Data": "DisplayName"},
                { "Name": "ServerType", "Title": resources.ServerType, "Data": "ServerTypeEnum" },
                { "Name": "ServerAddress", "Title": resources.ServerAddress, "Data": "ServerAddress" },
                { "Name": "ServerPort", "Title": resources.ServerPort, "Data": "ServerPort" },
                { "Name": "Active", "Title": resources.Active, "Data": "Active", "Type": "boolean", "ShowIcon" : true },
                { "Name": "UseSSL", "Title": resources.UseSSL + "/" + resources.TLS, "Data": "UseSSLValue", "Label": "UseSSLValueLabel" },
                { "Name": "Username", "Title": resources.Username, "Data": "Username" },
                { "Name": "TenantID", "Title": resources.TenantID, "Data": "TenantID" },
                { "Name": "LastConnectionStatus", "Title": resources.LastConnectionStatus, "Data": "LastConnectionStatusDisplay" },
                { "Name": "LastConnectionDate", "Title": resources.LastConnectionDate, "Data": "LastConnectionDate" },
                { "Name": "DefaultConfiguration", "Title": resources.DefaultConfiguration, "Data": "DefaultConfiguration", "Type": "boolean", "ShowIcon": true },
            ],
            localizableTexts: { "Search": resources.SearchOutgoingMailConfig },
            defaultSorting: "ServerAddress",
            toolBarItems: [{ "Action": "delete", "Label": resources.Delete }],
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];
               
                for (var i = 0; i < rows.length; i++) {
                        ids.push(rows[i].Id);                       
                }

                if (action == "delete") {
                        outgoing.deleteItems(ids);
                }
            },
            contextMenuItems: outgoing.getContextMenuItems(),
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "properties":                        
                        modalDialog.showWindow(a4.getAction("OutgoingMailEditor", "Distributions", "Settings", { id: row.Id }), 700, 650, { afterClose: function () { outgoing.refreshDataTable(); } });
                        break;

                    case "delete":
                        outgoing.deleteItems(row.Id, row.DefaultConfiguration);
                        break;

                    case "test":
                        outgoing.testItem(row.Id);
                        break;
                }
            }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-addOutgoing", function () {
            modalDialog.showWindow(a4.getAction("OutgoingMailEditor", "Distributions", "Settings"), 700, 650, { afterClose: function () { outgoing.refreshDataTable(); } });
        });        
    },
    getContextMenuItems: function () {
        var items = [];

        if (canModifyOutgoing) {
            items.push({ "Action": "test", "Label": resources.TestConnection });
            items.push({ "Divider": true });
            items.push({ "Action": "delete", "Label": resources.Delete });
            items.push({ "Action": "properties", "Label": resources.Properties });
        }

        return items;
    },
    deleteItems: function (items, defaultConfiguration) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }        
        if (defaultConfiguration) {
            modalDialog.showConfirmDialog(confirmDeleteDefaultConfigurationsResources, function () {
                a4.callServerMethod(a4.getAction("DeleteOutgoing", "Distributions", "Settings"), { itemIds: items },
                    function (result) {
                        outgoing.refreshDataTable();
                    });
            }, 250, 500, false, { "count": itemsCount });        
        }
        else {
            modalDialog.showConfirmDialog(confirmDeleteConfigurationsResources, function () {
                a4.callServerMethod(a4.getAction("DeleteOutgoing", "Distributions", "Settings"), { itemIds: items },
                    function (result) {
                        outgoing.refreshDataTable();
                    });
            }, 250, 500, true, { "count": itemsCount });
        }
    },
    testItem: function(id, serverType, address, port, username, password, useSSL, region, from, to) {
        a4.callServerMethod(a4.getAction("TestOutgoingConnection", "Distributions", "Settings"), { id: id, serverType: serverType, address: address, port: port, username: username, password: password, useSSL: useSSL, region: region, from: from, to: to },
            function (result) {
                if (result.success)
                    a4.showSuccessMessage(result.message);
                else
                    a4.showErrorMessage(result.message);               

                if (id > 0)
                    outgoing.refreshDataTable();
            });
    }
}

$(document).ready(function () {
    if ($(".v-outgoingMailTable").length > 0) {
        outgoing.initializeDataTable();
        outgoing.bindEvents();
    }
});